/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.perspectives;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.console.IConsoleConstants;

import alma.obops.tmcdbgui.handlers.IActionConstants;
import alma.obops.tmcdbgui.views.ConfigurationsView;
import alma.obops.tmcdbgui.views.NotificationChannelsView;
import alma.obops.tmcdbgui.views.SoftwareDeploymentView;

/**
 * This perspective contains the views related with the SW-side configuration
 * of the TMCDB
 *
 * @author rtobar, Feb 19, 2010
 * 
 */



public class SwConfigurationPerspective implements IPerspectiveFactory {

    public static final String ID = "sw-configuration.perspective";

    public void createInitialLayout( IPageLayout layout ) {

        layout.setEditorAreaVisible( true );
        layout.setFixed( false );

        String ea = layout.getEditorArea(); // general reference point

        // Folder containing Configurations and Software Deployment View, at the left
        IFolderLayout folder = layout.createFolder("main-objects.folder", IPageLayout.LEFT, 0.2f, ea);
        folder.addView( ConfigurationsView.ID );
        folder.addView( SoftwareDeploymentView.ID );

        // Bottom folder: NotificationsChannelView, Problems, SQL
        IPlaceholderFolderLayout folderPlaceholder = layout.createPlaceholderFolder("bottom.folder", IPageLayout.BOTTOM, 0.75f, ea);
        folderPlaceholder.addPlaceholder( NotificationChannelsView.ID );
        folderPlaceholder.addPlaceholder( IPageLayout.ID_PROBLEM_VIEW );
        folderPlaceholder.addPlaceholder( IConsoleConstants.ID_CONSOLE_VIEW );

        // Right: outline view
        layout.addPlaceholder( IPageLayout.ID_OUTLINE , IPageLayout.RIGHT, 0.8f, ea);

        // Shortcut to the Configurations Perspective
        layout.addPerspectiveShortcut(ConfigurationsPerspective.ID);

        // Allowed action sets
        layout.addActionSet(IActionConstants.NEW_TMCDB_OBJECTS_ACTIONSET);
    }
}