/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.perspectives;

import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;

import alma.obops.tmcdbgui.views.RawDataView;
import alma.obops.tmcdbgui.views.TableListView;

/**
 * This perspective contains the spreadsheet to edit the database in
 * expert mode.
 *
 * @author amchavan, Sep 3, 2008
 * 
 */



public class ExpertPerspective implements IPerspectiveFactory {
    
    public static final String ID = "expert.perspective";
    
    public void createInitialLayout( IPageLayout layout ) {
        layout.setEditorAreaVisible( false );
        layout.setFixed( false );

        String ea = layout.getEditorArea(); // general reference point
        layout.addView( TableListView.ID, IPageLayout.LEFT, 0.25f, ea );
        layout.addView( RawDataView.ID, IPageLayout.RIGHT, 0.75f, ea );
        layout.addView( IConsoleConstants.ID_CONSOLE_VIEW, IPageLayout.BOTTOM, 0.2f, RawDataView.ID );
    }
}
