/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.perspectives;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;

import alma.obops.tmcdbgui.handlers.IActionConstants;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.views.ConfigurationsView;
import alma.obops.tmcdbgui.views.SoftwareDeploymentView;
import alma.obops.tmcdbgui.views.StartupScenariosView;

/**
 * This perspective contains Configuration-related views
 *
 * @author amchavan, Sep 3, 2008
 * 
 */



public class ConfigurationsPerspective implements IPerspectiveFactory {
    
    public static final String ID = "configurations.perspective";
    
    public void createInitialLayout( IPageLayout layout ) 
    {
        layout.setEditorAreaVisible( false );
        layout.setFixed( false );

        String ea = layout.getEditorArea(); // general reference point
        
        FillLayout vbox = new FillLayout();
        vbox.type = SWT.VERTICAL;

        // Layout: the two trees at the top, a folder 
        //         with all editors at the bottom
        layout.addView( ConfigurationsView.ID, IPageLayout.TOP, 0.6f, ea );
        
        // Make sure none of our views can be closed
        //------------------------------------------
        layout.getViewLayout( ConfigurationsView.ID    ).setCloseable( false );

        layout.addView(IConsoleConstants.ID_CONSOLE_VIEW, IPageLayout.BOTTOM, 0.33f, layout.getEditorArea());
        
        // Add shortcut to Sw Perspective and view
        if(GuiUtils.isGodUser())
        {
        	layout.addView( StartupScenariosView.ID, IPageLayout.RIGHT, 0.5f, ea );
        	layout.getViewLayout( StartupScenariosView.ID  ).setCloseable( false );
        	layout.addPerspectiveShortcut(SwConfigurationPerspective.ID);
        	layout.addShowViewShortcut(SoftwareDeploymentView.ID);
        }
        
        // Allowed action sets
        layout.addActionSet(IActionConstants.NEW_TMCDB_OBJECTS_ACTIONSET);
    }
}
