/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 *
 */
package alma.obops.tmcdbgui.observablevalues;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import alma.obops.tmcdbgui.utils.GuiUtils;

/**
 * @author rtobar
 *
 */
public class LogLevelComboObservableValue extends AbstractObservableValue {

	private Byte oldValue;
	private Combo logLevelCombo;
	private final Map<String,Byte> logLevels = new HashMap<String, Byte>() {
		private static final long serialVersionUID = 1L;
		{
			put(GuiUtils.LOG_LEVEL_NOT_SPECIFIED,       (byte)-1);
			put(alma.AcsLogLevels.TRACE_NAME.value,     (byte)alma.AcsLogLevels.TRACE_VAL.value);
			put(alma.AcsLogLevels.DEBUG_NAME.value,     (byte)alma.AcsLogLevels.DEBUG_VAL.value);
			put(alma.AcsLogLevels.INFO_NAME.value,      (byte)alma.AcsLogLevels.INFO_VAL.value);
			put(alma.AcsLogLevels.NOTICE_NAME.value,    (byte)alma.AcsLogLevels.NOTICE_VAL.value);
			put(alma.AcsLogLevels.WARNING_NAME.value,   (byte)alma.AcsLogLevels.WARNING_VAL.value);
			put(alma.AcsLogLevels.ERROR_NAME.value,     (byte)alma.AcsLogLevels.ERROR_VAL.value);
			put(alma.AcsLogLevels.CRITICAL_NAME.value,  (byte)alma.AcsLogLevels.CRITICAL_VAL.value);
			put(alma.AcsLogLevels.ALERT_NAME.value,     (byte)alma.AcsLogLevels.ALERT_VAL.value);
			put(alma.AcsLogLevels.EMERGENCY_NAME.value, (byte)alma.AcsLogLevels.EMERGENCY_VAL.value);
			put(alma.AcsLogLevels.OFF_NAME.value,       (byte)alma.AcsLogLevels.OFF_VAL.value);
		}
	};

	public LogLevelComboObservableValue(Combo logLevelList) {

		Listener listener = new Listener() {
			public void handleEvent(Event event) {
				if( ((Combo)event.widget).getSelectionIndex() != -1 ) {
					Byte value = (Byte)doGetValue();
					if( oldValue == null || !oldValue.equals(value) ) {
						fireValueChange(Diffs.createValueDiff(oldValue, value));
						oldValue = value;
					}
				}
			}
		};

		logLevelList.addListener(SWT.Selection, listener);
		this.logLevelCombo = logLevelList;
	}

	@Override
	protected Object doGetValue() {
		return logLevels.get(logLevelCombo.getItem(logLevelCombo.getSelectionIndex()));
	}

	@Override
	public Object getValueType() {
		return Byte.class;
	}

	public void doSetValue(Object o) {
		Byte b = (Byte)o;

		int index = 0;
		for(String item: logLevelCombo.getItems()) {
			if( logLevels.get(item) == null && o == null )
				break;
			if( logLevels.get(item) != null && logLevels.get(item).equals(b) )
				break;
			index++;
		}
		logLevelCombo.select(index);
	}

}
