/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 *
 */
package alma.obops.tmcdbgui.observablevalues;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import alma.acs.tmcdb.ComponentImplLang;

/**
 * @author rtobar
 *
 */
public class ComponentImplLangComboObservableValue extends AbstractObservableValue {

	private ComponentImplLang oldValue;
	private Combo combo;

	private final Map<String, ComponentImplLang> langs = new HashMap<String, ComponentImplLang>() 
	{
		private static final long serialVersionUID = 1L;

		{
			put(ComponentImplLang.CPP.toString(), ComponentImplLang.CPP);  
			put(ComponentImplLang.JAVA.toString(), ComponentImplLang.JAVA);  
			put(ComponentImplLang.PY.toString(), ComponentImplLang.PY);  
		}
	};

	public ComponentImplLangComboObservableValue(Combo combo) {

		Listener listener = new Listener() {
			public void handleEvent(Event event) {
				if( ((Combo)event.widget).getSelectionIndex() != -1 ) {
					ComponentImplLang value = (ComponentImplLang)doGetValue();
					if( oldValue == null || !oldValue.equals(value) ) {
						fireValueChange(Diffs.createValueDiff(oldValue, value));
						oldValue = value;
					}
				}
			}
		};

		combo.addListener(SWT.Selection, listener);
		this.combo = combo;
	}

	@Override
	protected Object doGetValue() {
		return langs.get(combo.getItem(combo.getSelectionIndex()));
	}

	@Override
	public Object getValueType() {
		return ComponentImplLang.class;
	}

	public void doSetValue(Object o) {
		ComponentImplLang val = (ComponentImplLang)o;

		int index = 0;
		for(String item: combo.getItems()) {
			if( langs.get(item) == null && o == null )
				break;
			if( langs.get(item) != null && langs.get(item).equals(val))
				break;
			index++;
		}
		combo.select(index);
	}
}
