/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers.conversation;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.Action;

import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.domain.IModelChangePublisher;

public abstract class ModelPublisherAction extends Action implements IModelChangePublisher {

	protected List<IModelChangeListener> listeners = new ArrayList<IModelChangeListener>();

	public void addModelChangeListener(IModelChangeListener listener) {
		this.listeners.add(listener);
	}
	
	public void removeModelChangeListener(IModelChangeListener listener) {
		this.listeners.remove(listener);
	}
	
	public void modelChanged() {
		for(IModelChangeListener listener : listeners) {
			listener.internalModelChange();
		}
	}
	
	public void modelShouldBeReloaded() {
		for(IModelChangeListener listener : listeners) {
			listener.externalModelChange();
		}
	}
}

