/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Container;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;

/**
 * Undeploys a container from a computer. Used when drag-n-drop is not convenient, e.g. from a context menu.
 * @author sharring
 */
public class UndeployContainerAction extends AbstractMoveContainerAction
{
	private static final ImageDescriptor IMAGE_DESCRIPTOR = RcpUtils.getImageDescriptor("icons/undeploy.gif");
	private static final String TEXT_DESCRIPTOR = "Undeploy container...";
	private static final String TOOLTIPTEXT = "Undeploys a container from a computer";
	private static final String ID = "undeploy_container.action";

    public UndeployContainerAction(IWorkbenchWindow window) {
    	super(window);
    	this.setEnabled(GuiUtils.isGodUser());
    	this.setId(ID);
    	this.setToolTipText(TOOLTIPTEXT);
    	this.setText(TEXT_DESCRIPTOR);
    	this.setImageDescriptor(IMAGE_DESCRIPTOR);
    }

    @Override
    protected Computer getTargetComputer() throws NoComputerSelectedException {
    	return null;
    }

    @Override
    protected boolean validateSelectionItem(Object item) {
    	Container container = (Container)item;
		if( container.getComputer() != null )
			return true;
		return false;
    }

}