/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;

/**
 * Action factory to be used when creating actions that are used declaratively
 * from the plugin.xml file. This is based on the {@link ActionFactory} class,
 * but simplified since we don't use commands
 * 
 * SLH (12-13-2010) 
 * After some refactoring to support the new scientist mode and
 * also to fix COMP-4886, this class is no longer used. I will leave it 
 * in CVS for future reference in case we wish to resurrect this idea. 
 * Currently nobody is calling/using the instance variables here. Nor
 * are the actions noted here any longer declared in the plugin.xml file.
 *
 * @author rtobar, Sep 23th, 2010
 *
 */
public abstract class TmcdbActionFactory {

	public static final TmcdbActionFactory NEW_COMPUTER = new TmcdbActionFactory(IActionConstants.NEW_COMPUTER_ACTION) {
		public IAction create(IWorkbenchWindow window, Configuration config) {
			if( window == null )
				throw new IllegalArgumentException();
			final IAction delegate = new NewComputerAction(window, config);
			IAction action = new Action() {
				public void run() {
					delegate.run();
				}
			};
    		action.setId(getId());
    		action.setText("New Computer...");
    		action.setToolTipText("Creates a new computer");
    		action.setImageDescriptor(RcpUtils.getImageDescriptor("icons/computer-new.gif"));
    		action.setEnabled(GuiUtils.isGodUser());
    		return action;
		}
	};

	public static final TmcdbActionFactory NEW_COMPONENT = new TmcdbActionFactory(IActionConstants.NEW_COMPONENT_ACTION) {
		public IAction create(IWorkbenchWindow window, Configuration config) {
			if( window == null )
				throw new IllegalArgumentException();
			final IAction delegate = new NewComponentAction(window, config);
			IAction action = new Action() {
				public void run() {
					delegate.run();
				}
			};
    		action.setId(getId());
    		action.setText("New Component...");
    		action.setToolTipText("Creates a new component");
    		action.setImageDescriptor(RcpUtils.getImageDescriptor("icons/component-new.png"));
    		action.setEnabled(GuiUtils.isGodUser());
    		return action;
		}
	};

	public static final TmcdbActionFactory NEW_CONTAINER = new TmcdbActionFactory(IActionConstants.NEW_CONTAINER_ACTION) {
		public IAction create(IWorkbenchWindow window, Configuration config) {
			if( window == null )
				throw new IllegalArgumentException();
			final IAction delegate = new NewContainerAction(window, config);
			IAction action = new Action() {
				public void run() {
					delegate.run();
				}
			};
    		action.setId(getId());
    		action.setText("New Container...");
    		action.setToolTipText("Creates a new container");
    		action.setImageDescriptor(RcpUtils.getImageDescriptor("icons/container-new.gif"));
    		action.setEnabled(GuiUtils.isGodUser());
    		return action;
		}
	};

	public static final TmcdbActionFactory NEW_BACIPROPERTY = new TmcdbActionFactory(IActionConstants.NEW_BACIPROPERTY_ACTION) {
		public IAction create(IWorkbenchWindow window, Configuration config) {
			if( window == null )
				throw new IllegalArgumentException();
			final IAction delegate = new NewBACIPropertyAction(window, config);
			IAction action = new Action() {
				public void run() {
					delegate.run();
				}
			};
    		action.setId(getId());
    		action.setText("New BACI Property...");
    		action.setToolTipText("Creates a new BACI Property");
    		action.setImageDescriptor(RcpUtils.getImageDescriptor("icons/baci-property-new.gif"));
    		action.setEnabled(GuiUtils.isGodUser());
    		return action;
		}
	};

	private String _actionId;

	public abstract IAction create(IWorkbenchWindow window, Configuration config);

	public TmcdbActionFactory(String actionId) {
		_actionId = actionId;
	}

	public String getId() {
		return _actionId;
	}
}
