/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ShowDefaultCanAddressesAction.java
 */
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.IConsoleConstants;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;

/**
 * Action for showing the DeviceLibraries view
 * 
 * @author rtobar, Sep 23rd, 2010
 */
public class ShowSQLConsoleAction extends Action 
{
	private String ID = "alma.obops.tmcdbgui.handlers.ShowSQLConsoleAction";

	public ShowSQLConsoleAction()
	{
    	setId(ID);
        setText("Show SQL Console");
		setToolTipText("Shows a console with full SQL logging");
		setImageDescriptor( RcpUtils.getImageDescriptor( "icons/sql.gif" ));
		setEnabled(GuiUtils.isGodUser());
	}

	public void run() 
	{
		IViewPart consoleView = RcpUtils.findView(IConsoleConstants.ID_CONSOLE_VIEW);
		if( consoleView != null )
			consoleView.setFocus();
		else
			throw new RuntimeException("Cannot obtain the Console view");
	}

}
