/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ShowNotificationChannelsAction.java
 */
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.views.NotificationChannelsView;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Action for showing a Configurartion's Notification Channels.
 * @author rtobar, Mar 23, 2010
 */
public class ShowNotificationChannelsAction extends Action implements ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdbgui.handlers.ShowNotificationChannelsAction";

	public ShowNotificationChannelsAction(IWorkbenchWindow window)
	{
		_window = window;
    	setId(ID);
        setText("Notification Channels");
		setToolTipText("Show the Notification Channels in a separate view");
		setImageDescriptor( RcpUtils.getImageDescriptor( "icons/nc-view.png" ));
    	_window.getSelectionService().addSelectionListener(this);
	}
	
	public void run() 
	{
		try {
			HwConfiguration conf = (HwConfiguration)_selection.getFirstElement();
			_window.getWorkbench().showPerspective(SwConfigurationPerspective.ID, _window);
			NotificationChannelsView ncView = (NotificationChannelsView)RcpUtils.findView(NotificationChannelsView.ID, true);
			if( ncView != null ) {
				ncView.getNCViewer().setInput(conf);
				ncView.setFocus();
			} else {
				throw new RuntimeException("Cannot obtain the Notification Channels view");
			}
		} catch (WorkbenchException e) {
			e.printStackTrace();
			// TODO Proper exception handling?
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection ) {
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 && GuiUtils.isGodUser() &&
				       _selection.getFirstElement() instanceof HwConfiguration);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
