/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ShowDefaultCanAddressesAction.java
 */
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.views.DefaultCanAddressView;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Action for showing a Configurartion's DefaultCanAddress objects
 * @author rtobar, Mar 23, 2010
 */
public class ShowDefaultCanAddressesAction extends Action implements ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdbgui.handlers.ShowDefaultCanAddressesAction";

	public ShowDefaultCanAddressesAction(IWorkbenchWindow window)
	{
		_window = window;
    	setId(ID);
        setText("CAN/Ethernet configuration");
		setToolTipText("Show the CAN/Ethernet configurations in a separate view");
		setImageDescriptor( RcpUtils.getImageDescriptor( "icons/default-can-address.gif" ));
    	_window.getSelectionService().addSelectionListener(this);
	}

	public void run() 
	{
		HwConfiguration conf = (HwConfiguration)_selection.getFirstElement();
		DefaultCanAddressView ncView = (DefaultCanAddressView)RcpUtils.findView(DefaultCanAddressView.ID);
		if( ncView != null ) {
			ncView.getDCAViewer().setInput(conf);
			ncView.setFocus();
		} else {
			throw new RuntimeException("Cannot obtain the Notification Channels view");
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection ) {
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 && GuiUtils.isGodUser() &&
			            _selection.getFirstElement() instanceof HwConfiguration);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
