/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import alma.obops.tmcdbgui.views.TableListView;

/**
 * Reload the list of tables
 *
 * @author amchavan, Sep 5, 2008
 * 
 */



public class ReloadTableListAction implements IViewActionDelegate {
    
    public static final String ID = "reloadTableList.action";
    protected TableListView view;

    /**
     * Save the view for future reference
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init( IViewPart theView ) {
        this.view = (TableListView) theView;
    }

    /**
     * Reload the list of tables
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run( IAction action ) {
        
        // TODO uncomment
//        Object[] tableList;
//        
//        try {
//        	
//        	HibernateUtils hibernateUtils = DamContextFactory.INSTANCE.getHibernateUtils();
//            DatabaseMetaData meta = hibernateUtils.getMetaData();
//
//            Vector<Object> temp = new Vector<Object>();
//            String[] types = { "TABLE" };
//            ResultSet tables = meta.getTables( null, null, null, types );
//            
//            /*
//               1. TABLE_CAT String => table catalog (may be null)
//               2. TABLE_SCHEM String => table schema (may be null)
//               3. TABLE_NAME String => table name
//               4. TABLE_TYPE String => table type. Typical types are "TABLE", "VIEW", "SYSTEM TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "ALIAS", "SYNONYM".
//               5. REMARKS String => explanatory comment on the table
//               6. TYPE_CAT String => the types catalog (may be null)
//               7. TYPE_SCHEM String => the types schema (may be null)
//               8. TYPE_NAME String => type name (may be null)
//               9. SELF_REFERENCING_COL_NAME String => name of the designated "identifier" column of a typed table (may be null)
//              10. REF_GENERATION String => specifies how values in SELF_REFERENCING_COL_NAME are created. Values are "SYSTEM", "USER", "DERIVED". (may be null)
//             */
//            while( tables.next() ) {
//                temp.add( tables.getString( 3 ));
//            }
//            tableList = temp.toArray();
//            view.setInput( tableList );
//            RcpUtils.statusMessage( "Found " + temp.size() + " tables" );
//        }
//        catch( SQLException e ) {
//            e.printStackTrace();
//            MessageDialog.openError( view.getSite().getShell(), "SQL Error", 
//                                     e.getMessage() );
//        }
    }

    /**
     * No-op
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged( IAction action, ISelection selection ) {
        // no-op
    }
}
