/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.utils.conversation.SwConfigurationConversationUtils;
import alma.obops.tmcdbgui.wizards.NewNotificationServiceMappingWizard;

public class NewNotificationServiceMappingAction extends Action implements
		ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection _selection;
    private IWorkbenchWindow _window;
    private final static String ID = "new_notificationservicemapping.action";
    private Configuration _configuration;

    public NewNotificationServiceMappingAction() {}

    public NewNotificationServiceMappingAction(IWorkbenchWindow window, Configuration config) 
    {
    	_window = window;
    	_configuration = config;
    	_window.getSelectionService().addSelectionListener(this);
    	setEnabled(GuiUtils.isGodUser());
    	setId(ID);
    	this.setEnabled(GuiUtils.isGodUser());
    	this.setToolTipText("Creates a new Notification Service Mapping definition");
    	this.setText("New Notification Service Mapping...");
    	this.setImageDescriptor(RcpUtils.getImageDescriptor("icons/new-notificationservice-mapping.gif"));
    }

	@Override
	public void run() 
	{
		NewNotificationServiceMappingWizard wizard = new NewNotificationServiceMappingWizard(_configuration);
    	wizard.init(_window.getWorkbench(), _selection);
    	WizardDialog dialog = new WizardDialog(_window.getShell(), wizard);
    	dialog.create();
    	dialog.open();
	}

	@Override
	public void dispose() 
	{
		_window.getSelectionService().removeSelectionListener(this);
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		if( selection instanceof IStructuredSelection && GuiUtils.isGodUser()) 
		{
			_selection = (IStructuredSelection)selection;
			if( _selection.getFirstElement() instanceof NotificationServiceMapping[]) 
			{
				try {
					SwConfigurationConversationUtils.getInstance().hydrateNotificationServiceMappings(_configuration);
				} catch (Exception e) {
					e.printStackTrace();
					throw new RuntimeException("Could not hydrate notification service mappings");
				}
				if(_configuration.getNotificationServiceMappings() == null || _configuration.getNotificationServiceMappings().size() == 0) {
					setEnabled(true);
				}
				else {
					setEnabled(false);
				}
			}
			else {
				setEnabled(false);
			}
		}
		else {
			setEnabled(false);
		}
	}

	public void setConfiguration(Configuration swConfiguration) {
		this._configuration = swConfiguration;
	}
}
