/*
 * ALMA - Atacama Large Millimiter Array (c) European Southern Observatory, 2011
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.DefaultCanAddress;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.editors.DefaultCanAddressEditor;
import alma.obops.tmcdbgui.editors.inputs.DefaultCanAddressEditorInput;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.utils.conversation.DefaultCanAddressConversationUtils;

/**
 * Creates a new DefaultCanAddress, attached to the selected component
 *
 * @author rtobar, July 26th, 2011
 */
public class NewDefaultCanAddressAction extends Action implements ISelectionListener, IWorkbenchAction 
{
	private static final String ID = "add_startup.action";
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private Component _component; 

    /**
     * Constructor.
     * @param window the window associated with this action.
     */
    public NewDefaultCanAddressAction(IWorkbenchWindow window) 
    {
    	_window = window;
		setId(ID);
    	setText("New CAN/Ethernet configuration");
        setImageDescriptor( RcpUtils.getImageDescriptor( "icons/default-can-address-new.gif" ));
    	_window.getSelectionService().addSelectionListener(this);
    }

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection newSelection) 
	{
		if( newSelection instanceof IStructuredSelection )
		{
			_selection = (IStructuredSelection)newSelection;
			if( _selection.size() == 1 && GuiUtils.isGodUser() &&
			   (_selection.getFirstElement() instanceof Component) ) {
				setEnabled(true);
				_component = (Component)_selection.getFirstElement();
			}
			else
				setEnabled(false);
		}
		else
			setEnabled(false);
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
		
	}

	@Override
	public void run() {

		try {

			// Create a new, empty CAN DCA
			DefaultCanAddress dca = new DefaultCanAddress();
			dca.setComponent(_component);
			dca.setIsEthernet(false);
			dca.setNodeAddress("00");
			dca.setChannelNumber((byte)0);
			dca.setHostname("");
			dca.setPort(0);
			dca.setMacAddress("00:00:00:00:00:00");
			dca.setRetries((short)0);
			dca.setTimeOutRxTx(0.0);
			dca.setLingerTime(0);
			DefaultCanAddressConversationUtils.getInstance().saveOrUpdate(dca);

			// Now open it in an editor
			DefaultCanAddressEditorInput dcaEI = new DefaultCanAddressEditorInput(dca);
			_window.getActivePage().openEditor(dcaEI, DefaultCanAddressEditor.ID);
		} catch (Throwable t) {
			t.printStackTrace();
		}

	}

	
}
