/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.hibernate.criterion.MatchMode;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.handlers.conversation.ModelPublisherAction;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.obops.tmcdbgui.views.IConfigurationSearcher;
import alma.obops.tmcdbgui.wizards.NewConfigurationWizard;
import alma.tmcdb.domain.HwConfiguration;

public class NewConfigurationAction extends ModelPublisherAction implements
		ISelectionListener, IWorkbenchAction 
{
	private IConfigurationSearcher searcher;
	private IWorkbenchWindow _window;
	private String ID = "new_configuration.action";
	private HwConfiguration newConfig;
	 
	public NewConfigurationAction(IWorkbenchWindow window, IModelChangeListener listener, IConfigurationSearcher searcher) 
	{
		_window = window;
		this.addModelChangeListener(listener);
		setId(ID);
		setText("&Configuration...");
		setToolTipText("Creates a new Configuration");
		setImageDescriptor( RcpUtils.getImageDescriptor( "icons/configuration-new.png" ));
		_window.getSelectionService().addSelectionListener(this);
		this.searcher = searcher;
		setEnabled(GuiUtils.isGodUser());
	}

	public void run() 
	{
		IWizard wizard = new NewConfigurationWizard(this);
		WizardDialog wizardDialog = new WizardDialog(_window.getShell(), wizard);
		
		if(wizardDialog.open() != WizardDialog.CANCEL)
		{
			if(null != newConfig) 
			{
				try 
				{
					HwConfigurationConversationUtils.getInstance().updateConfiguration(newConfig);
					searcher.setSearchCriteria(newConfig.getName(), true, false, MatchMode.EXACT);
					this.modelShouldBeReloaded();
				} 
				catch (Exception e) 
				{
					throw new RuntimeException("Could not save new configuration" + e);
				}
			}
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		// noop
 	}

	@Override
	public void dispose() 
	{
		_window.getSelectionService().removeSelectionListener(this);
	}


	public void setConfiguration(HwConfiguration configuration) {
		this.newConfig = configuration;
	}
}
