/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComputerAction.java
 *
 * Copyright European Southern Observatory 2010
 */

package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.views.SoftwareDeploymentView;
import alma.obops.tmcdbgui.wizards.NewComputerWizard;

/**
 * Starts up a {@link NewComputerWizard}
 *
 * @author rtobar, Mar 4, 2010
 * 
 */



public class NewComputerAction extends Action implements ISelectionListener, IWorkbenchAction, IPerspectiveListener  {

    private IStructuredSelection _selection;
    private IWorkbenchWindow _window;
    private final static String ID = "new_computer.action";
    private Configuration configuration;

    public NewComputerAction() {}

    public NewComputerAction(IWorkbenchWindow window, Configuration config) {
    	_window = window;
    	_window.addPerspectiveListener(this);
    	_window.getSelectionService().addSelectionListener(this);
    	setEnabled(GuiUtils.isGodUser());
    	setId(ID);
    	this.setEnabled(GuiUtils.isGodUser());
    	this.setToolTipText("Creates a new Computer");
    	this.setText("New Computer...");
    	this.setImageDescriptor(RcpUtils.getImageDescriptor("icons/computer-new.gif"));
    	this.configuration = config;
    }

	@Override
	public void run() {
		NewComputerWizard wizard = new NewComputerWizard(configuration);
    	wizard.init(_window.getWorkbench(), _selection);
    	WizardDialog dialog = new WizardDialog(_window.getShell(), wizard);
    	dialog.create();
    	dialog.open();
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
		_window.removePerspectiveListener(this);
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection && GuiUtils.isGodUser()) 
		{
			_selection = (IStructuredSelection)selection;
			if( _selection.getFirstElement() instanceof Computer[]) {
				setEnabled(true);
			}
			else {
				setEnabled(false);
			}
		}
		else {
			setEnabled(false);
		}
	}

	public void setConfiguration(Configuration configuration)
	{
		this.configuration = configuration;
	}

	@Override
	public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) 
	{
		perspectiveChanged(page, perspective, null);
	}

	@Override
	public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId)  
	{
		if(page.getPerspective().getId() == SwConfigurationPerspective.ID) {
			SoftwareDeploymentView view = (SoftwareDeploymentView) RcpUtils.findView(SoftwareDeploymentView.ID);
			this.configuration = view.getHwConfiguration().getSwConfiguration();
		}
	}
}
