/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComponentAction.java
 *
 * Copyright European Southern Observatory 2010
 */

package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.wizards.NewComponentTypeWizard;

/**
 * Starts up a {@link NewComponentTypeWizard}
 *
 * @author rtobar, Mar 2, 2010
 * 
 */



public class NewComponentTypeAction extends Action {

	private Shell _shell;
	private String ID = "new_component.action";

    public NewComponentTypeAction(Shell shell) {
    	setId(ID);
        setText("Co&mponent Type...");
		setToolTipText("Creates a new Component Type");
        setImageDescriptor( RcpUtils.getImageDescriptor( "icons/component-type-new.png" ));
        _shell = shell;
        setEnabled(GuiUtils.isGodUser());
    }

    public void run() {
    	NewComponentTypeWizard wizard = new NewComponentTypeWizard();
    	wizard.init(null, null);
    	WizardDialog dialog = new WizardDialog(_shell, wizard);
    	dialog.create();
    	dialog.setBlockOnOpen(true);
    	dialog.open();
    }

}
