/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import java.util.Date;

import alma.tmcdb.domain.AntennaType;
import alma.tmcdb.domain.Coordinate;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Convenience interface which can be implemented by things which need
 * to have antenna attributes set.
 */
public interface IAssignNewAntennaAttributes {

	public void setName(String name);

	public void setType(AntennaType type);

	public void setPosition(Coordinate position);

	public void setOffset(Coordinate offset);

	public void setDiameter(Double diameter);

	public void setCommissionDate(Date commissionDate);

	public void setCableDelay(Double cableDelay);
	
	public void setConfiguration(HwConfiguration config);

	public void setLoOffsetting(Integer loOffsetting);

	public void setWalshSequence(Integer walshSequence);

	public void setCorrelatorInputBaseline(Integer input);
	public void setCorrelatorInputAca(Integer input);
}
