/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdbgui.editors.XpDelaysEditor;
import alma.obops.tmcdbgui.editors.inputs.XpDelaysEditorInput;
import alma.obops.tmcdbgui.perspectives.ConfigurationsPerspective;
import alma.obops.tmcdbgui.views.providers.helpers.config.XpDelaysModel;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Action used to invoke the xp delays (cross polarization delays) editor.
 * @author sharring
 */
public class EditXpDelaysAction extends Action implements ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdbgui.handlers.EditXpDelaysAction";

	public EditXpDelaysAction(IWorkbenchWindow window)
	{
		_window = window;
    	setId(ID);
        setText("Edit XP Delays");
		setToolTipText("Opens the XP delays in an editor");
    	_window.getSelectionService().addSelectionListener(this);	
	}
	
	public void run() 
	{
		try {
			XpDelaysModel delayModel = (XpDelaysModel)_selection.getFirstElement();
			XpDelaysEditorInput editorInput = new XpDelaysEditorInput(delayModel.getConfiguration());
			_window.getWorkbench().showPerspective(ConfigurationsPerspective.ID, _window);
			_window.getActivePage().openEditor(editorInput, XpDelaysEditor.ID);
		} catch (Exception e) {
			throw new RuntimeException("Problem editing XP delays", e);
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		if( selection instanceof IStructuredSelection ) 
		{
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 &&
			            _selection.getFirstElement() instanceof HwConfiguration);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
