/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.editors.PointingModelEditor;
import alma.obops.tmcdbgui.editors.inputs.PointingModelEditorInput;
import alma.obops.tmcdbgui.perspectives.ConfigurationsPerspective;
import alma.tmcdb.domain.PointingModel;

/**
 * Action to invoke pointing model editor.
 * @author sharring
 */
public class EditPointingModelAction extends Action implements
		ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdbgui.handlers.EditPointingModelAction";
	private IModelChangeListener listener;

	public EditPointingModelAction(IWorkbenchWindow window, IModelChangeListener listener)
	{
		_window = window;
    	setId(ID);
        setText("Edit Pointing Model");
		setToolTipText("Opens the Pointing Model in an editor");
    	_window.getSelectionService().addSelectionListener(this);	
    	this.listener = listener;
	}
	
	public void run() 
	{
		try 
		{
			PointingModel pm = (PointingModel)selection.getFirstElement();
			PointingModelEditorInput pmEditorInput = new PointingModelEditorInput(pm, listener);
			_window.getWorkbench().showPerspective(ConfigurationsPerspective.ID, _window);
			_window.getActivePage().openEditor(pmEditorInput, PointingModelEditor.ID);
		} 
		catch (WorkbenchException e) {
			throw new RuntimeException("Problem editing pointing model", e);
		}
	}
	
	@Override
	public void selectionChanged(IWorkbenchPart window, ISelection newSelection) 
	{
		if( newSelection instanceof IStructuredSelection ) {
			selection = (IStructuredSelection)newSelection;
			setEnabled( selection.size() == 1 &&
			            selection.getFirstElement() instanceof PointingModel);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}

}
