/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.editors.PadEditor;
import alma.obops.tmcdbgui.editors.inputs.PadEditorInput;
import alma.obops.tmcdbgui.perspectives.ConfigurationsPerspective;
import alma.tmcdb.domain.Pad;

/**
 * Action for editing pads.
 * @author sharring
 */
public class EditPadAction extends Action implements ISelectionListener, IWorkbenchAction 
{

	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdbgui.handlers.EditPadAction";
	private IModelChangeListener listener;

	public EditPadAction(IWorkbenchWindow window, IModelChangeListener listener)
	{
		_window = window;
    	setId(ID);
        setText("Edit Front End");
		setToolTipText("Opens the Front End in an editor");
    	_window.getSelectionService().addSelectionListener(this);	
    	this.listener = listener;
	}
	
	public void run() 
	{
		try {
			Pad pad = (Pad)_selection.getFirstElement();
			PadEditorInput padEditorInput = new PadEditorInput(pad, listener);
			_window.getWorkbench().showPerspective(ConfigurationsPerspective.ID, _window);
			_window.getActivePage().openEditor(padEditorInput, PadEditor.ID);
		} catch (WorkbenchException e) {
			e.printStackTrace();
			// TODO Proper exception handling?
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection ) {
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 &&
			            _selection.getFirstElement() instanceof Pad);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
