/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.DomainsMapping;
import alma.obops.tmcdbgui.editors.DomainsMappingEditor;
import alma.obops.tmcdbgui.editors.inputs.DomainsMappingEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

public class EditDomainsMappingAction extends AbstractEditObjectAction 
{
	private String ID = "alma.obops.tmcdbgui.handlers.EditDomainsMappingAction";

    public EditDomainsMappingAction(IWorkbenchWindow window) {
    	super(DomainsMapping.class, true, window);
    	setId(ID);
        setText("Edit NS Domains Mapping");
		setToolTipText("Opens the NS Domains Mapping in an editor");
    }

    public void run() {

    	try {
    		DomainsMapping service = (DomainsMapping)_selection.getFirstElement();
    		DomainsMappingEditorInput input = new DomainsMappingEditorInput(service);
    		_window.getWorkbench().showPerspective(SwConfigurationPerspective.ID, _window);
    		_window.getActivePage().openEditor(input, DomainsMappingEditor.ID);
    	} catch (WorkbenchException e) {
    		e.printStackTrace();
    		// TODO Proper exception handling?
    	}
    }
}
