/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.editors.DelayModelEditor;
import alma.obops.tmcdbgui.editors.inputs.DelayModelEditorInput;
import alma.obops.tmcdbgui.perspectives.ConfigurationsPerspective;
import alma.obops.tmcdbgui.views.providers.helpers.config.DelayModel;

/**
 * Action for editing a delay model.
 * @author sharring
 */
public class EditDelayModelAction extends Action implements ISelectionListener,
		IWorkbenchAction 
{
	private IStructuredSelection selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdbgui.handlers.EditDelayModelAction";
	private IModelChangeListener listener;
	
	public EditDelayModelAction(IWorkbenchWindow window, IModelChangeListener listener)
	{
		_window = window;
    	setId(ID);
        setText("Edit Delay Model");
		setToolTipText("Opens the Delay Model in an editor");
    	_window.getSelectionService().addSelectionListener(this);	
    	this.listener = listener;
	}
	
	public void run() 
	{
		try 
		{
			DelayModel dm = (DelayModel)selection.getFirstElement();
			DelayModelEditorInput dmEditorInput = new DelayModelEditorInput(dm, listener);
			_window.getWorkbench().showPerspective(ConfigurationsPerspective.ID, _window);
			_window.getActivePage().openEditor(dmEditorInput, DelayModelEditor.ID);
		} 
		catch (WorkbenchException e) {
			throw new RuntimeException("Problem editing delay model", e);
		}
	}
	
	@Override
	public void selectionChanged(IWorkbenchPart window, ISelection newSelection) 
	{
		if( newSelection instanceof IStructuredSelection ) {
			selection = (IStructuredSelection)newSelection;
			setEnabled( selection.size() == 1 &&
			            selection.getFirstElement() instanceof DelayModel);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
