/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.DefaultCanAddress;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.editors.DefaultCanAddressEditor;
import alma.obops.tmcdbgui.editors.inputs.DefaultCanAddressEditorInput;

/**
 * Opens the currently selected DefaultCanAddress in a DefaultCanAddress Editor
 *
 * @author rtobar, Aug 18th, 2010
 * 
 */


public class EditDefaultCanAddressAction extends AbstractEditObjectAction {

	private String ID = "alma.obops.tmcdbgui.handlers.EditDefaultCanAddressAction";

    public EditDefaultCanAddressAction(IWorkbenchWindow window) {
    	super(DefaultCanAddress.class, true, window);
    	setId(ID);
        setText("Edit CAN/Ethernet configuration");
		setToolTipText("Opens the CAN/Ethernet configuration in an editor");
		setImageDescriptor( RcpUtils.getImageDescriptor("icons/default-can-address.gif") );
    }

    public void run() {

    	try {
    		DefaultCanAddress dca = (DefaultCanAddress)_selection.getFirstElement();
    		DefaultCanAddressEditorInput dcaei = new DefaultCanAddressEditorInput(dca);
    		_window.getActivePage().openEditor(dcaei, DefaultCanAddressEditor.ID);
    	} catch (WorkbenchException e) {
    		e.printStackTrace();
    		// TODO Proper exception handling?
    	}
    }

}
