/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.editors.ConfigurationEditor;
import alma.obops.tmcdbgui.editors.inputs.ConfigurationEditorInput;
import alma.tmcdb.domain.HwConfiguration;

public class EditConfigurationAction extends AbstractEditObjectAction {

	private IModelChangeListener modelChangeListener;
	private String ID = "alma.obops.tmcdbgui.handlers.EditConfigurationAction";

    public EditConfigurationAction(IWorkbenchWindow window, IModelChangeListener listener) 
    {
    	super(HwConfiguration.class, true, window);
    	setId(ID);
        setText("Edit Configuration");
		setToolTipText("Opens the Configuration in an editor");
    	this.modelChangeListener = listener;
    }

    public void run() 
    {
    	try {
        	HwConfiguration config = (HwConfiguration)_selection.getFirstElement();
        	ConfigurationEditorInput confEdInp = new ConfigurationEditorInput(config, this.modelChangeListener);
    		_window.getActivePage().openEditor(confEdInp, ConfigurationEditor.ID);
    	} catch (WorkbenchException e) {
    		e.printStackTrace();
    		// TODO Proper exception handling?
    	}
    }

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		if( selection instanceof IStructuredSelection) {
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 &&
			            _selection.getFirstElement() instanceof HwConfiguration);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
