/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * EditComputerAction.java
 *
 * Copyright European Southern Observatory 2010
 */

package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.Computer;
import alma.obops.tmcdbgui.editors.ComputerEditor;
import alma.obops.tmcdbgui.editors.inputs.ComputerEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

/**
 * Opens the currently selected Computer in a Computer Editor
 *
 * @author rtobar, Mar 4, 2010
 * 
 */



public class EditComputerAction extends AbstractEditObjectAction {

	private String ID = "alma.obops.tmcdbgui.handlers.EditComputerAction";

    public EditComputerAction(IWorkbenchWindow window) {
    	super(Computer.class, true, window);
    	setId(ID);
        setText("Edit Computer");
		setToolTipText("Opens the Computer in an editor");
    }

    public void run() {

    	try {
        	Computer comp = (Computer)_selection.getFirstElement();
        	ComputerEditorInput cei = new ComputerEditorInput(comp);
    		_window.getWorkbench().showPerspective(SwConfigurationPerspective.ID, _window);
    		_window.getActivePage().openEditor(cei, ComputerEditor.ID);
    	} catch (WorkbenchException e) {
    		e.printStackTrace();
    		// TODO Proper exception handling?
    	}
    }

}