/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * EditComponentAction.java
 *
 * Copyright European Southern Observatory 2010
 */

package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.Component;
import alma.obops.tmcdbgui.editors.ComponentEditor;
import alma.obops.tmcdbgui.editors.inputs.ComponentEditorInput;
import alma.obops.tmcdbgui.utils.conversation.ComponentConversationUtils;

/**
 * Opens the currently selected Component in a Component Editor
 *
 * @author rtobar, Mar 2, 2010
 * 
 */



public class EditComponentAction extends AbstractEditObjectAction {

	private String ID = "alma.obops.tmcdbgui.handlers.EditComponentAction";

    public EditComponentAction(IWorkbenchWindow window) {
    	super(Component.class, true, window);
    	setId(ID);
        setText("Edit Component");
		setToolTipText("Opens the Component in an editor");
    }

    public void run() {
    	Component comp = (Component)_selection.getFirstElement();
    	try {
    		ComponentConversationUtils.getInstance().hydrateContainer(comp);
    		ComponentEditorInput cei = new ComponentEditorInput(comp);
    		_window.getActivePage().openEditor(cei, ComponentEditor.ID);
    	}
    	catch(Exception ex) {
    		ex.printStackTrace();
    		throw new RuntimeException(ex);
    	}
    }
}