/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.ChannelMapping;
import alma.obops.tmcdbgui.editors.ChannelMappingEditor;
import alma.obops.tmcdbgui.editors.inputs.ChannelMappingEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

public class EditChannelMappingAction extends AbstractEditObjectAction 
{
	private String ID = "alma.obops.tmcdbgui.handlers.EditDomainsMappingAction";

    public EditChannelMappingAction(IWorkbenchWindow window) {
    	super(ChannelMapping.class, true, window);
    	setId(ID);
        setText("Edit NS Channel Mapping");
		setToolTipText("Opens the NS Channel Mapping in an editor");
    }

    public void run() {

    	try {
    		ChannelMapping service = (ChannelMapping)_selection.getFirstElement();
    		ChannelMappingEditorInput input = new ChannelMappingEditorInput(service);
    		_window.getWorkbench().showPerspective(SwConfigurationPerspective.ID, _window);
    		_window.getActivePage().openEditor(input, ChannelMappingEditor.ID);
    	} catch (WorkbenchException e) {
    		e.printStackTrace();
    		// TODO Proper exception handling?
    	}
    }
}
