/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.editors.inputs.AssemblyXmlEditorInput;
import alma.obops.tmcdbgui.external.xmleditor.XMLEditor;
import alma.obops.tmcdbgui.perspectives.ConfigurationsPerspective;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.utils.conversation.AssemblyConversationUtils;
import alma.tmcdb.domain.Assembly;

public class EditAssemblyAction extends Action implements ISelectionListener, IWorkbenchAction, IConfigurationUpdater
{
	private static final String OPTICALTELESCOPE = "OpticalTelescope";
	private IWorkbenchWindow window;
    private IStructuredSelection selection;
    private Assembly assembly;
	private String ID = "alma.obops.tmcdbgui.handlers.EditAssemblyAction";

	public EditAssemblyAction(IWorkbenchWindow window) {
		this.window = window;
		setId(ID);
		setText("Edit Assembly");
		setToolTipText("Opens the Assembly in an editor");
		window.getSelectionService().addSelectionListener(this);
	}

	public void run() {
		try
		{
		   assembly = (Assembly)selection.getFirstElement();
		   AssemblyXmlEditorInput assEdInp = new AssemblyXmlEditorInput(assembly, this);
		   AssemblyConversationUtils.getInstance().hydrateAssembly(assembly);
		   try {
				window.getWorkbench().showPerspective(ConfigurationsPerspective.ID, window);
				window.getActivePage().openEditor(assEdInp, XMLEditor.ID);
				RcpUtils.findView(IPageLayout.ID_OUTLINE, window.getActivePage());
			} catch (WorkbenchException e) {
				e.printStackTrace();
				// TODO Proper exception handling?
			}
		}
		catch(Exception ex) {
			GuiUtils.showErrorDialog(window.getShell(), "Error", "Could not hydrate assembly");
			ex.printStackTrace();
		}
    }
	
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection slection) 
	{
		if( slection instanceof IStructuredSelection && GuiUtils.isGodUser()) {
			selection = (IStructuredSelection)slection;
			setEnabled( selection.size() == 1 &&
			            selection.getFirstElement() instanceof Assembly);	
		}
		else if(slection instanceof IStructuredSelection) {
			selection = (IStructuredSelection)slection;
			setEnabled( selection.size() == 1 &&
		            selection.getFirstElement() instanceof Assembly &&
		            ((Assembly)selection.getFirstElement()).getAssemblyType().getName().equalsIgnoreCase(OPTICALTELESCOPE));
		}
	}

	@Override
	public void dispose() {
		window.getSelectionService().removeSelectionListener(this);
	}

	@Override
	public void updateConfiguration() {
		try {
			AssemblyConversationUtils.getInstance().saveOrUpdateAssembly(assembly);
		} catch (Exception e) {
			GuiUtils.showErrorDialog(window.getShell(), "Error", "Could not save assembly");
			e.printStackTrace();
		}
	}
}
