/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.AcsService;
import alma.obops.tmcdbgui.editors.AcsServiceEditor;
import alma.obops.tmcdbgui.editors.inputs.AcsServiceEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;
import alma.obops.tmcdbgui.views.support.AcsServiceWrapper;

/**
 * Class which allows the user to edit a "wrapped" acs service. 
 *
 * @author sharring
 *
 * @see alma.obops.tmcdbgui.views.support.AcsServiceWrapper
 */
public class EditAcsServiceWrapperAction extends AbstractEditObjectAction 
{
	private static String ID = "alma.obops.tmcdbgui.handlers.EditAcsServiceWrapperAction";

    public EditAcsServiceWrapperAction(IWorkbenchWindow window) {
    	super(AcsServiceWrapper.class, true, window);
		setId(ID);
        setText("Edit ACS Service");
		setToolTipText("Opens the ACS Service in an editor");
	}

	public void run() {

    	try {
    		AcsService service = getAcsService();
    		AcsServiceEditorInput input = new AcsServiceEditorInput(service);
    		_window.getWorkbench().showPerspective(SwConfigurationPerspective.ID, _window);
    		_window.getActivePage().openEditor(input, AcsServiceEditor.ID);
    	} catch (WorkbenchException e) {
    		e.printStackTrace();
    		// TODO Proper exception handling?
    	}
    }
	
	protected AcsService getAcsService() 
	{
		AcsService retVal = ((AcsServiceWrapper)_selection.getFirstElement()).getAcsService();
		return retVal;
	}

}
