/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.ui.IWorkbenchWindow;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.BaseElementType;

/**
 * Action to delete a weather station from a configuration. Note that db constraints may prevent this 
 * in some situations.
 * 
 * @author sharring
 */
public class DeleteWeatherStationAction extends AbstractDeleteBaseElementAction 
{
	private static final String ID = "delete_weatherstation.action";
    
	public DeleteWeatherStationAction(IWorkbenchWindow window)
	{
		super(window);
		setId(ID);
		setText("Delete weather station controller");
		setToolTipText("Deletes a weather station controller");
		setImageDescriptor( RcpUtils.getImageDescriptor( "icons/weatherstation-delete.png" ));
	}
	
	protected BaseElementType getType()
	{
		return BaseElementType.WeatherStationController;
	}
	
	protected String getConstraintViolationErrorMessage()
	{
		return "This weatherstation cannot be deleted due to DB constraints. One possible cause of this may be that the weather station is in a hw startup";
	}
}
