/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.wizards.CloneAntennaWizard;
import alma.tmcdb.domain.Antenna;

/**
 * Action to clone an antenna within a configuration.
 * @author sharring
 */
public class CloneAntennaAction extends CloneBaseElementAction 
{
	private static final String ID = "clone_antenna.action";

	/**
	 * Constructor.
	 * @param baseElement the antenna to clone	
	 * @param view the tree viewer containing the antenna.
	 */
	public CloneAntennaAction(IWorkbenchWindow window, IModelChangeListener listener) {
		super(window);
		setId(ID);
		setText("Clone Antenna");
		setToolTipText("Clones an existing Antenna");
		setImageDescriptor( RcpUtils.getImageDescriptor( "icons/antenna-clone.png" ));
		this.addModelChangeListener(listener);
	}

	@Override public void doPreConversational()
	{
		try {
			workbenchWindow.getShell().setCursor(workbenchWindow.getShell().getDisplay().getSystemCursor(SWT.CURSOR_WAIT));
			// Collect user input
			cancelled = false;
			CloneAntennaWizard wizard = new CloneAntennaWizard( this, (Antenna)selection.getFirstElement());
			WizardDialog dialog = new WizardDialog( workbenchWindow.getShell(), wizard );
			int ret = dialog.open();
			if( ret == WizardDialog.CANCEL ) {
				cancelled = true;
				return;
			}
		}
		catch( Exception e ) {
			e.printStackTrace();
			MessageDialog.openError( workbenchWindow.getShell(), 
					"Cloning of Antenna",
					e.getClass().getSimpleName() + 
					": " + e.getMessage() );
		}
		finally {
			workbenchWindow.getShell().setCursor(null);
		}
	}
	
	public void selectionChanged(IWorkbenchPart part, ISelection newSelection) {
		if( newSelection instanceof IStructuredSelection && GuiUtils.isGodUser()) {
			selection = (IStructuredSelection)newSelection;
			setEnabled( selection.size() == 1 && 
					selection.getFirstElement() instanceof Antenna );
		}
		else {
			setEnabled(false);
		}
	}
}
