/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.wizards.BulkComponentChangesWizard;
import alma.tmcdb.domain.HwConfiguration;

public class BulkComponentChangesByHwConfigurationAction extends Action implements ISelectionListener, IWorkbenchAction
{
	public String ID = "bulk-component-changes-hwconfiguration.action";

	private HwConfiguration _hwconf;
	protected IStructuredSelection _selection;
	protected IWorkbenchWindow _window;

	public BulkComponentChangesByHwConfigurationAction(IWorkbenchWindow window) {
		_window = window;
		_window.getSelectionService().addSelectionListener(this);
		setId(ID);
		setText("Edit Components");
		setToolTipText("Performs bulk changes on Components");
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection && GuiUtils.isGodUser()) {
			_selection = (IStructuredSelection)selection;
			setEnabled( ((IStructuredSelection) selection).size() == 1 &&
					_selection.getFirstElement() instanceof HwConfiguration);
			if( _selection.getFirstElement() instanceof HwConfiguration )
				_hwconf = (HwConfiguration)_selection.getFirstElement();
		}
		else
			setEnabled(false);
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
	
	 public void run() {
	    	IWizard wizard = new BulkComponentChangesWizard(_hwconf.getSwConfiguration(), this._window);
	    	WizardDialog dialog = new WizardDialog(_window.getShell(), wizard);
	    	dialog.create();
	    	dialog.open();
	    }
	 
	 public ImageDescriptor getImageDescriptor() {
			return RcpUtils.getImageDescriptor("icons/component-edit.png");
		}
}
