/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.wizards.BulkBACIPropertiesChangesWizard;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Concrete implementation of {@link AbstractBulkBACIPropertiesChangesAction}, used to start
 * the {@link BulkBACIPropertiesChangesWizard} with a selected Configuration
 *
 * @author rtobar, June 29, 2010
 *
 */
public class BulkBACIPropertiesCreationByHwConfigurationAction extends
		AbstractBulkBACIPropertiesCreationAction {

	public String ID = "bulk-baci-creation-hwconfiguration.action";

	private HwConfiguration _hwconf;

	public BulkBACIPropertiesCreationByHwConfigurationAction(IWorkbenchWindow window) {
		super(window);
	}

	@Override
	protected String getActionId() {
		return ID;
	}

	@Override
	protected Configuration getConfiguration() {
		return _hwconf.getSwConfiguration();
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection && GuiUtils.isGodUser()) {
			_selection = (IStructuredSelection)selection;
			setEnabled( ((IStructuredSelection) selection).size() == 1 &&
					_selection.getFirstElement() instanceof HwConfiguration);
			if( _selection.getFirstElement() instanceof HwConfiguration )
				_hwconf = (HwConfiguration)_selection.getFirstElement();
		}
		else
			setEnabled(false);
	}

}
