/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.utils.conversation.AssemblyTypeConversationUtils;
import alma.obops.tmcdbgui.views.ConfigurationsView;
import alma.obops.tmcdbgui.views.providers.typedlists.AssemblyList;
import alma.obops.tmcdbgui.wizards.BulkBACIPropertiesChangesWizard;
import alma.tmcdb.domain.Assembly;

/**
 * Concrete implementation of {@link AbstractBulkBACIPropertiesChangesAction}, used to start
 * the {@link BulkBACIPropertiesChangesWizard} with a selected Assembly Type
 *
 * This action is supposed to be used with AssemblyType objects. Nevertheless, since the AssemblyType
 * table is independent of the HwConfiguration/Configuration ones, an actual Assembly for the given
 * Assembly Type is needed to get the proper reference to Configuration.
 * 
 * In the {@link ConfigurationsView} view, Assemblies are grouped under the AssemblyList object
 *             
 * @author rtobar, July 6th, 2010
 *
 */
public class BulkBACIPropertiesChangesByAssemblyTypeAction extends
		AbstractBulkBACIPropertiesChangesAction {

	public String ID = "bulk-baci-changes-assemblytype.action";

	private Assembly _assembly;

	public BulkBACIPropertiesChangesByAssemblyTypeAction(IWorkbenchWindow window) {
		super(window);
	}

	@Override
	protected String getActionId() {
		return ID;
	}

	@Override
	protected ComponentType getComponentType() {
		try {
			AssemblyTypeConversationUtils.getInstance().hydrateComponentType(_assembly.getAssemblyType());
		} catch (Exception e) {
			// TODO: error handling
			e.printStackTrace(System.err);
		}
		return _assembly.getAssemblyType().getComponentType();
	}

	@Override
	protected Configuration getConfiguration() {
		return _assembly.getConfiguration().getSwConfiguration();
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection && GuiUtils.isGodUser()) {
			_selection = (IStructuredSelection)selection;
			setEnabled( ((IStructuredSelection) selection).size() == 1 &&
					_selection.getFirstElement() instanceof AssemblyList );
			if( _selection.getFirstElement() instanceof AssemblyList )
				_assembly = ((AssemblyList)_selection.getFirstElement()).iterator().next();
		}
		else
			setEnabled(false);
	}

}
