/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.obops.tmcdbgui.utils.GuiUtils;

public class AbstractEditObjectAction extends Action implements ISelectionListener, IWorkbenchAction {

	private Class<?> _objectClazz;
	private boolean _onlyForGod;
	protected IStructuredSelection _selection;
    protected IWorkbenchWindow _window;

    public AbstractEditObjectAction(Class<?> objectClazz, boolean onlyForGod, IWorkbenchWindow window) {
    	_objectClazz = objectClazz;
    	_onlyForGod = onlyForGod;
    	_window = window;
    	_window.getSelectionService().addSelectionListener(this);
    }

	/**
	 * Runs this action, if available, as the result of double-clicking
	 * an object in a view.
	 *
	 * @param selection The selection coming from the {@link DoubleClickEvent} event
	 */
	public void runWithDoubleClick(ISelection selection) {
		internalSelectionChanged(selection);
		run();
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if( selection instanceof IStructuredSelection && (!_onlyForGod || (_onlyForGod && GuiUtils.isGodUser())))
			 internalSelectionChanged(selection);
	}

	private void internalSelectionChanged(ISelection selection) {
		_selection = (IStructuredSelection)selection;
		 setEnabled( _selection.size() == 1 &&
				 _objectClazz.isAssignableFrom( _selection.getFirstElement().getClass() ));
	}
}