/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.wizards.BulkBACIPropertiesChangesWizard;

/**
 * Starts up a {@link BulkBACIPropertiesChangesWizard}.
 *
 * Note that this class is abtract. Child classes must implement the {@link #getConfiguration()}
 * and {@link #getComponentType()} methods, which retrieve the objects that will be passed, in turn,
 * to the wizard; and the {@link #selectionChanged(IWorkbenchPart, ISelection)} method, which should
 * decide when the action becomes enabled or disabled.
 *
 * @author rtobar, June 29, 2010
 * 
 */



public abstract class AbstractBulkBACIPropertiesChangesAction extends AbstractBulkBACIPropertiesAction {

    public AbstractBulkBACIPropertiesChangesAction(IWorkbenchWindow window) {
		super(window);
        setText("Edit BACI Properties");
		setToolTipText("Performs bulk changes on BACI properties");
	}

	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/baci-property-edit-bulk.gif");
	}

	protected IWizard getWizard() {
		return new BulkBACIPropertiesChangesWizard(getConfiguration(), getComponentType());
	}
}