/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Configuration;

/**
 * Abstract class for all actions that open a wizard for bulk modifications on BACIProperties.
 *
 * @author rtobar, Oct 18, 2010
 * 
 */



public abstract class AbstractBulkBACIPropertiesAction extends Action implements ISelectionListener, IWorkbenchAction {

    protected IStructuredSelection _selection;
    protected IWorkbenchWindow _window;

    public AbstractBulkBACIPropertiesAction(IWorkbenchWindow window) {
    	_window = window;
    	setId(getActionId());
    	_window.getSelectionService().addSelectionListener(this);
    }

    public void run() {
    	IWizard wizard = getWizard();
    	WizardDialog dialog = new WizardDialog(_window.getShell(), wizard);
    	dialog.create();
    	dialog.open();
    }

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		return;
	}

	/**
	 * Returns the Configuration object that must be used through the bulk changes
	 * @return The Configuration
	 */
	protected Configuration getConfiguration() {
		return null;
	}

	/**
	 * Returns the initial ComponentType object that should be used through the bulk changes.
	 * @return The ComponentType. It might be null
	 */
	protected ComponentType getComponentType() {
		return null;
	}

	/**
	 * Returns the child class action ID
	 * @return The child class Action ID
	 */
	protected abstract String getActionId();

	/**
	 * Returns a new instance of the wizard to be used launched by this action
	 * @return The wizard to launch with this action
	 */
	protected abstract IWizard getWizard();

	@Override
	public abstract ImageDescriptor getImageDescriptor();

}