/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * Created on Oct 10, 2004
 */
package alma.obops.tmcdbgui.external.xmleditor.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

import alma.acs.logging.AcsLogLevel;

/**
 * @author Phil Zoio
 */
public class XMLValidationErrorHandler extends DefaultHandler
{

	private List<XMLValidationError> errorList = new ArrayList<XMLValidationError>();
	private Locator locator;
	private Logger  logger;

	public XMLValidationErrorHandler(Logger logger)
	{
		this.logger = logger;
	}

	public void error(SAXParseException e) throws SAXException
	{

		handleError(e, false);

	}
	
	
	public void setDocumentLocator(Locator locator)
	{
		this.locator = locator;
	}
	
	
	private void handleError(SAXParseException e, boolean isFatal)
	{
		XMLValidationError validationError = nextError(e, isFatal);
		errorList.add(validationError);
	}

	protected XMLValidationError nextError(SAXParseException e, boolean isFatal)
	{
		String errorMessage = e.getMessage();

		int lineNumber = locator.getLineNumber();
		int columnNumber = locator.getColumnNumber();

		log(isFatal, "Error on line " + lineNumber + ", column " + columnNumber + ": " + errorMessage);

		XMLValidationError validationError = new XMLValidationError();
		validationError.setLineNumber(lineNumber);
		validationError.setColumnNumber(columnNumber);
		validationError.setErrorMessage(errorMessage);
		return validationError;
	}

	private void log(boolean isFatal, String string)
	{
		Level level;
		if( isFatal )
			level = AcsLogLevel.ERROR;
		else
			level = AcsLogLevel.WARNING;
		logger.log(level, string);
	}

	public void fatalError(SAXParseException e) throws SAXException
	{
		handleError(e, true);
	}

	public List<XMLValidationError> getErrorList()
	{
		return errorList;
	}

}

