/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * Created on Oct 10, 2004
 */
package alma.obops.tmcdbgui.external.xmleditor.xml;



/**
 * 
 * @author Phil Zoio
 */
public class XMLValidationError
	{
	    private String errorMessage;
	    private int lineNumber;
	    private int columnNumber;

	    public String getErrorMessage()
	    {
	        return errorMessage;
	    }

	    public void setErrorMessage(String errorMessage)
	    {
	        this.errorMessage = errorMessage;
	    }

	    public int getLineNumber()
	    {
	        return lineNumber;
	    }

	    public void setLineNumber(int lineNumber)
	    {
	        this.lineNumber = lineNumber;
	    }

	    public int getColumnNumber()
	    {
	        return columnNumber;
	    }

	    public void setColumnNumber(int columnNumber)
	    {
	        this.columnNumber = columnNumber;
	    }

	    public String toString()
	    {
	        StringBuffer buf = new StringBuffer();
	        buf.append("Error on ")
	            .append(" line ")
	            .append(lineNumber)
	            .append(", column ")
	            .append(columnNumber)
	            .append(": ")
	            .append(errorMessage);
	        return buf.toString();
	    }
	}

