/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * Created on Oct 11, 2004
 */
package alma.obops.tmcdbgui.external.xmleditor.xml;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Phil Zoio
 */
public class XMLTree
{

	private XMLElement rootElement;
	private List<XMLElement> allElements = new ArrayList<XMLElement>();
	private List<String> allAttributes = new ArrayList<String>();

	public XMLTree()
	{

		super();
		rootElement = new XMLElement("world");
		XMLElement continent = newDTDElement("continent");
		rootElement.addChildElement(continent);

		continent.addChildAttribute(new XMLAttribute("name")).addChildAttribute(new XMLAttribute("population"));
		addAttribute("name");
		addAttribute("population");

		XMLElement continentDescription = newDTDElement("description");
		continent.addChildElement(continentDescription);

		XMLElement country = newDTDElement("country");
		country.addChildAttribute(new XMLAttribute("name")).addChildAttribute(new XMLAttribute("population"));
		continent.addChildElement(country);

		XMLElement countryDescription = newDTDElement("description");
		country.addChildElement(countryDescription);
		XMLElement countryAttraction = newDTDElement("attraction");
		country.addChildElement(countryAttraction);
		countryAttraction.addChildAttribute(new XMLAttribute("name"));

		XMLElement city = newDTDElement("city");
		city.addChildAttribute(new XMLAttribute("name")).addChildAttribute(new XMLAttribute("population"));
		country.addChildElement(city);

		XMLElement cityDescription = newDTDElement("description");
		city.addChildElement(cityDescription);
		XMLElement cityAttraction = newDTDElement("attraction");
		cityAttraction.addChildAttribute(new XMLAttribute("name"));
		cityAttraction.addChildAttribute(new XMLAttribute("cost"));
		city.addChildElement(cityAttraction);
		addAttribute("cost");

		XMLElement ocean = newDTDElement("ocean");
		continent.addChildElement(ocean);
		ocean.addChildAttribute(new XMLAttribute("name"));
		ocean.addChildAttribute(new XMLAttribute("depth"));
		addAttribute("depth");

	}

	private XMLElement newDTDElement(String elementName)
	{
		XMLElement element = new XMLElement(elementName);
		allElements.add(element);
		return element;
	}

	private void addAttribute(String attributeName)
	{
		if (!allAttributes.contains(attributeName))
		{
			allAttributes.add(attributeName);
		}
	}

	public List<XMLElement> getAllElements()
	{
		return allElements;
	}

	public List<String> getAllAttributes()
	{
		return allAttributes;
	}

	public XMLElement getRootElement()
	{
		return rootElement;
	}

	public void setRootElement(XMLElement rootElement)
	{
		this.rootElement = rootElement;
	}
}