/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * Created on Oct 10, 2004
 */
package alma.obops.tmcdbgui.external.xmleditor.xml;

import java.io.StringReader;

import javax.xml.XMLConstants;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * Performs DTD validation on supplied XML document
 */
public class XMLParser
{

	private ErrorHandler errorHandler;
	private ContentHandler contentHandler;

	public void setErrorHandler(ErrorHandler errorHandler)
	{
		this.errorHandler = errorHandler;
	}

	public void setContentHandler(ContentHandler contentHandler)
	{
		this.contentHandler = contentHandler;
	}

	public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
	public static final String VALIDATION_SCHEMA_FEATURE = "http://apache.org/xml/features/validation/schema";

	/**
	 * Does DTD-based validation on text
	 */
	public void doParse(String xmlText, String schemaText) throws RuntimeException
	{
		if(xmlText == null || xmlText.length() == 0)
		{
			return;
		}
		InputSource inputSource = new InputSource(new StringReader(xmlText));
		doParse(inputSource, schemaText);

	}

	/**
	 * Does DTD-based validation on inputSource
	 */
	public void doParse(InputSource inputSource, String schemaText) throws RuntimeException
	{
		try
		{
			if( schemaText != null ) {

				SAXParserFactory factory = SAXParserFactory.newInstance();
				SAXSource source = null;
				source = new SAXSource(new InputSource(new StringReader(schemaText)));
				factory.setNamespaceAware(true);
				factory.setSchema( SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI).newSchema(source) );
				SAXParser parser = factory.newSAXParser();
				XMLReader reader = parser.getXMLReader();
				reader.setErrorHandler(errorHandler);
				reader.setContentHandler(contentHandler);
				reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation",source.getSystemId());
				reader.parse(inputSource);

			}
			else {			
				XMLReader reader = XMLReaderFactory.createXMLReader();
				reader.setErrorHandler(errorHandler);
				reader.setContentHandler(contentHandler);
				reader.parse(inputSource);
			}

		}
		catch (Exception e)
		{
			throw new RuntimeException(e);
		}
	}

}

