/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * Created on Oct 11, 2004
 */
package alma.obops.tmcdbgui.external.xmleditor.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.text.Position;

/**
 * @author Phil Zoio
 */
public class XMLElement
{

	private List<XMLElement> elementChildren = new ArrayList<XMLElement>();
	private List<XMLAttribute> attributeChildren = new ArrayList<XMLAttribute>();

	private String name;
	private XMLElement parent;
	private Position position;

	public XMLElement(String name)
	{
		super();
		this.name = name;
	}

	public List<XMLElement> getChildrenDTDElements()
	{
		return elementChildren;
	}

	public XMLElement addChildElement(XMLElement element)
	{
		elementChildren.add(element);
		element.setParent(this);
		return this;
	}

	public void setParent(XMLElement element)
	{
		this.parent = element;
	}

	public XMLElement getParent()
	{
		return parent;
	}

	public XMLElement addChildAttribute(XMLAttribute attribute)
	{
		attributeChildren.add(attribute);
		return this;
	}

	public String getName()
	{
		return name;
	}
	
	public String getAttributeValue(String localName)
	{
		for (Iterator<XMLAttribute> iter = attributeChildren.iterator(); iter.hasNext();)
		{
			XMLAttribute attribute = iter.next();
			if (attribute.getName().equals(localName)) return attribute.getValue();
		}
		return null;
	}

	public void clear()
	{
		elementChildren.clear();
		attributeChildren.clear();
	}

	public void setPosition(Position position)
	{
		this.position = position;
	}

	public Position getPosition()
	{
		return position;
	}
}