/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*
 * Created on Oct 12, 2004
 */
package alma.obops.tmcdbgui.external.xmleditor.outline;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import alma.obops.tmcdbgui.external.xmleditor.xml.XMLAttribute;
import alma.obops.tmcdbgui.external.xmleditor.xml.XMLElement;
import alma.obops.tmcdbgui.external.xmleditor.xml.XMLTree;

/**
 * @author Phil Zoio
 */
public class OutlineContentHandler extends DefaultHandler
{

    private XMLTree dtdTree;

    private XMLElement dtdElement;

    private Locator locator;

    private IDocument document;

    private String positionCategory;

    public OutlineContentHandler()
    {
        super();
    }

    public void setDocumentLocator(Locator locator)
    {
        this.locator = locator;
    }

    public void startElement(String namespace, String localname, String qName, Attributes attributes)
            throws SAXException
    {

        int lineNumber = locator.getLineNumber() - 1;
        XMLElement element = new XMLElement(localname);

        int startPosition = getOffsetFromLine(lineNumber);
        Position position = new Position(startPosition);

        addPosition(position);
        element.setPosition(position);

        if (dtdTree == null)
        {
            this.dtdTree = new XMLTree();
            this.dtdTree.setRootElement(element);
        }

        if (attributes != null)
        {
            int attributeLength = attributes.getLength();
            for (int i = 0; i < attributeLength; i++)
            {
                String value = attributes.getValue(i);
                String localName = attributes.getLocalName(i);

                element.addChildAttribute(new XMLAttribute(localName, value));
            }
        }

        if (dtdElement != null)
            dtdElement.addChildElement(element);

        dtdElement = element;

    }

    public void endElement(String namespace, String localname, String qName) throws SAXException
    {

        int lineNumber = locator.getLineNumber();
        int endPosition = getOffsetFromLine(lineNumber);

        if (dtdElement != null)
        {

            Position position = dtdElement.getPosition();
            int length = endPosition - position.getOffset();
            position.setLength(length);

            dtdElement = dtdElement.getParent();

        }
    }

    private void addPosition(Position position)
    {
        try
        {
            document.addPosition(positionCategory, position);
        }
        catch (BadLocationException e)
        {
            e.printStackTrace();
        }
        catch (BadPositionCategoryException e)
        {
            e.printStackTrace();
        }
    }

    public void endDocument() throws SAXException
    {
        super.endDocument();
    }

    private int getOffsetFromLine(int lineNumber)
    {
        int offset = 0;
        try
        {
            offset = document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e)
        {
            try
            {
                offset = document.getLineOffset(lineNumber - 1);
            }
            catch (BadLocationException e1)
            {
            }
        }
        return offset;
    }

    public XMLElement getRootElement()
    {
        return dtdTree.getRootElement();
    }

    public void setDocument(IDocument document)
    {
        this.document = document;
    }

    public void setPositionCategory(String positionCategory)
    {
        this.positionCategory = positionCategory;
    }

}