/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * 
 */
package alma.obops.tmcdbgui.external.xmleditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

import alma.obops.tmcdbgui.editors.inputs.IXmlEditorInput;
import alma.obops.tmcdbgui.external.xmleditor.scanners.XMLPartitionScanner;

/**
 * This DocumentProviders gets the inner XML field from the given {@link IXmlEditorInput}.
 * Then it interacts with the editor input object to get and set the XML string from/to it.
 * 
 * @author rtobar, June 14th, 2010
 */

public class XMLDocumentProvider extends AbstractDocumentProvider {

	private boolean readOnly;
	
	@Override
	protected IAnnotationModel createAnnotationModel(Object element)
			throws CoreException 
	{
		return null;
	}

	@Override
	protected IDocument createDocument(Object element) throws CoreException 
	{
		if( !(element instanceof IXmlEditorInput) )
			throw new CoreException(STATUS_ERROR);

		IDocument document = new Document();
		document.set( ((IXmlEditorInput)element).getXmlForEditedObject() );

		IDocumentPartitioner partitioner = new XMLPartitioner(new XMLPartitionScanner(), new String[]
		                                                                                            {
			XMLPartitionScanner.XML_START_TAG,
			XMLPartitionScanner.XML_PI,
			XMLPartitionScanner.XML_DOCTYPE,
			XMLPartitionScanner.XML_END_TAG,
			XMLPartitionScanner.XML_TEXT,
			XMLPartitionScanner.XML_CDATA,
			XMLPartitionScanner.XML_COMMENT
		                                                                                            });
		partitioner.connect(document);
		document.setDocumentPartitioner(partitioner);
	    return document;
	}

	@Override
	protected void doSaveDocument(IProgressMonitor monitor, Object element,
			IDocument document, boolean overwrite) throws CoreException 
	{
		((IXmlEditorInput)element).setXmlForEditedObject(document.get());
	}

	@Override
	protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
		return null;
	}

	@Override
	public boolean isReadOnly(Object element) 
	{
		return readOnly;
	}

	@Override
	public boolean isModifiable(Object element) 
	{
		return !readOnly;
	}
	
	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}
	
}
