/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.sorters;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import alma.obops.tmcdbgui.views.providers.LoDelayModelRow;

public class LoDelayViewerSorter extends ViewerSorter
{
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		LoDelayModelRow delay1 = (LoDelayModelRow) e1;
		LoDelayModelRow delay2 = (LoDelayModelRow) e2;
		int rc = delay1.getDelay().getBaseband().toString().compareTo(delay2.getDelay().getBaseband().toString());
		return rc;
	}
}
