/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import java.util.Set;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.XPDelay;

/**
 * Editor input for the xp delay editor.
 * @author sharring
 */
public class XpDelaysEditorInput implements TmcdbObjectEditorInput 
{
	private HwConfiguration configuration;
	
	public HwConfiguration getConfiguration() 
	{
		return this.configuration;
	}
	
	public String getConfigurationName() {
		return configuration.getName();
	}

	private Set<XPDelay> xpDelays;
	
	public XpDelaysEditorInput(HwConfiguration configuration)
	{
		this.configuration = configuration;
		this.setXpDelays(configuration.getCrossPolarizationDelays());
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/delays.png");
	}

	@Override
	public String getName() {
		return "XP delays for config: " + this.configuration.getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return "XP delays";
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	private void setXpDelays(Set<XPDelay> xpdelays) {
		this.xpDelays = xpdelays;
	}

	public Set<XPDelay> getXpDelays() {
		return xpDelays;
	}

	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof XpDelaysEditorInput) )
			return false;

		XpDelaysEditorInput editorInput = (XpDelaysEditorInput)o;
		String inputConfigurationName = editorInput.getConfigurationName();

		if( inputConfigurationName != null && this.getConfigurationName() != null ) 
		{
			if( this.getConfigurationName().equals(inputConfigurationName) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getConfigurationName() == null ? 0 : this.getConfigurationName().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getConfiguration();
	}
}
