/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComponentEditorInput
 */
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.editors.StartupScenarioEditor;
import alma.tmcdb.domain.StartupScenario;

/**
 * Input wrapper for the {@link StartupScenarioEditor} editor.
 * @author rtobar, Mar 18, 2010
 *
 */
public class StartupScenarioEditorInput implements TmcdbObjectEditorInput {

	private StartupScenario _se;
	private IModelChangeListener modelChangeListener;

	/**
	 * Constructor.
	 * @param se the startup scenario that is being edited.
	 * @param listener a model change listener that will be notified if there is a change to the model;
	 *        this can be null, if no notifications are needed.
	 */
	public StartupScenarioEditorInput(StartupScenario se, IModelChangeListener listener) {
		_se = se;
		this.modelChangeListener = listener;
	}

	public IModelChangeListener getModelChangeListener() {
		return modelChangeListener;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/startup.png");
	}

	@Override	public String getName() {
		return _se.getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + _se.getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public StartupScenario getStartupScenario() {
		return _se;
	}

	public void setStartupScenario(StartupScenario se) {
		_se = se;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof StartupScenarioEditorInput) )
			return false;

		StartupScenarioEditorInput seei = (StartupScenarioEditorInput)o;
		StartupScenario se = seei.getStartupScenario();

		if( se.getId() != null && _se.getId() != null ) {
			if( _se.getId().equals(se.getId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getStartupScenario() == null ? 0 : this.getStartupScenario().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getStartupScenario();
	}
}
