/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.PointingModel;

/**
 * Editor input for pointing model history editor.
 * 
 * @author sharring
 *
 */
public class PointingModelHistoryEditorInput implements IEditorInput 
{
	private PointingModel pointingModel;

	public PointingModelHistoryEditorInput(PointingModel pm) 
	{
		this.pointingModel = pm;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/pointingmodel-history.png");
	}

	@Override	public String getName() {
		return "Pointing model history for " + pointingModel.getAntenna().getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + pointingModel.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public PointingModel getPointingModel() {
		return this.pointingModel;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o)) {
			return true;
		}
		if( !(o instanceof PointingModelHistoryEditorInput) ) {
			return false;
		}

		PointingModelHistoryEditorInput pmEditorInput = (PointingModelHistoryEditorInput)o;
		PointingModel inputPointingModel = pmEditorInput.getPointingModel();

		if(inputPointingModel == null && pointingModel == null) 
		{
			return true;
		}
		else if(inputPointingModel == null && pointingModel != null) 
		{
			return false;
		}
		else if(inputPointingModel != null && pointingModel == null) 
		{
			return false;
		} 
		else if(inputPointingModel != null && pointingModel != null)
		{
			if(inputPointingModel.getId() == null && pointingModel.getId() == null)
			{
				if(inputPointingModel.getAntenna().getId().equals(pointingModel.getAntenna().getId()))
				{
					return true;
				}
				return false;
			} 
			else if(inputPointingModel.getId() == null && pointingModel.getId() != null) 
			{
				return false;
			}
			else if(inputPointingModel.getId() != null && pointingModel.getId() == null) 
			{
				return false;
			}
			else if( inputPointingModel.getId() != null && pointingModel.getId() != null ) 
			{
				if( pointingModel.getId().equals(inputPointingModel.getId()) ) {
					return true;
				}
				return false;
			}
		}
		
		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getPointingModel() == null || this.getPointingModel().getId() == null) ? 0 : this.getPointingModel().getId().hashCode();
		return retVal;
	}
}
