/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.tmcdb.domain.PointingModel;

/**
 * EditorInput for pointing model.
 * @author sharring
 */
public class PointingModelEditorInput implements TmcdbObjectEditorInput 
{
	private PointingModel pointingModel;
	private IModelChangeListener modelChangeListener;
	
	public PointingModelEditorInput(PointingModel pm,
			IModelChangeListener listener) 
	{
		pointingModel = pm;
		this.modelChangeListener = listener;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		// TODO - add an icon
		return RcpUtils.getImageDescriptor("icons/pointingmodel.png");
	}

	public String getName() {
		return "Pointing model for " + pointingModel.getAntenna().getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + pointingModel.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}
	
	public PointingModel getPointingModel()
	{
		return this.pointingModel;
	}
	
	public IModelChangeListener getModelChangeListener()
	{
		return this.modelChangeListener;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof PointingModelEditorInput) )
			return false;

		PointingModelEditorInput pmEditorInput = (PointingModelEditorInput)o;
		PointingModel inputPm = pmEditorInput.getPointingModel();

		if( inputPm.getId() != null && this.getPointingModel().getId() != null ) 
		{
			if( this.getPointingModel().getId().equals(inputPm.getId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getPointingModel() == null || this.getPointingModel().getId() == null) ? 0 : this.getPointingModel().getId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getPointingModel();
	}
}
